// script.js
function generateRecommendation() {
  // Get user inputs
  const skinType = document.getElementById("skinType").value;
  const skinConcerns = document.getElementById("skinConcerns").value;
  const productPreference = document.getElementById("productPreference").value;

  // Define possible recommendations based on skin type, concerns, and preferences
  const recommendations = {
    oily: {
      acne: [
        "Oil-Free Cleanser",
        "Mattifying Moisturizer",
        "Salicylic Acid Serum",
      ],
      aging: ["Hydrating Serum", "Anti-Aging Cream", "Exfoliating Mask"],
      dryness: ["Moisturizing Cleanser", "Hydrating Gel", "Lightweight Cream"],
      pigmentation: ["Vitamin C Serum", "Brightening Mask", "SPF 50 Sunscreen"],
      sensitivity: ["Gentle Cleanser", "Soothing Gel", "Calming Face Cream"],
    },
    dry: {
      acne: ["Gentle Cleanser", "Hydrating Toner", "Acne Treatment Gel"],
      aging: ["Rich Moisturizer", "Firming Serum", "Anti-Aging Cream"],
      dryness: [
        "Hydrating Cleanser",
        "Moisturizing Serum",
        "Intensive Hydration Cream",
      ],
      pigmentation: [
        "Brightening Serum",
        "Vitamin C Cream",
        "SPF 30 Sunscreen",
      ],
      sensitivity: [
        "Calming Cleanser",
        "Moisturizing Face Oil",
        "Gentle Recovery Cream",
      ],
    },
    combination: {
      acne: ["Balancing Cleanser", "BHA Toner", "Pore Minimizing Mask"],
      aging: ["Firming Serum", "Anti-Aging Eye Cream", "Night Repair Cream"],
      dryness: ["Hydrating Cleanser", "Balancing Serum", "Moisturizing Cream"],
      pigmentation: [
        "Brightening Toner",
        "Vitamin C Serum",
        "SPF 50 Sunscreen",
      ],
      sensitivity: [
        "Gentle Foaming Cleanser",
        "Calming Toner",
        "Sensitive Skin Cream",
      ],
    },
    sensitive: {
      acne: ["Soothing Cleanser", "Acne Treatment Serum", "Hydrating Mask"],
      aging: [
        "Gentle Anti-Aging Cream",
        "Soothing Serum",
        "Hydrating Night Cream",
      ],
      dryness: [
        "Ultra-Hydrating Cleanser",
        "Sensitive Skin Moisturizer",
        "Soothing Serum",
      ],
      pigmentation: [
        "Gentle Brightening Serum",
        "Soothing Mask",
        "SPF 30 Sunscreen",
      ],
      sensitivity: [
        "Fragrance-Free Cleanser",
        "Soothing Recovery Balm",
        "Anti-Redness Serum",
      ],
    },
  };

  // Get the recommendation list based on user selection
  const userRecommendation = recommendations[skinType][skinConcerns];

  // Display the result
  const resultDiv = document.getElementById("recommendationResult");
  const recommendationList = document.getElementById("recommendationList");

  // Clear previous recommendations
  recommendationList.innerHTML = "";

  // Add each product to the recommendation list
  userRecommendation.forEach((product) => {
    const li = document.createElement("li");
    li.textContent = product;
    recommendationList.appendChild(li);
  });

  // Show the recommendations
  resultDiv.classList.remove("hidden");
}
